/*
 * Copyright (c) 2019 Amazon.com, Inc. or its affiliates.  All rights
 * reserved.
 * Portions Copyright (C) 2018 Sigmastar Technology Corp
 *
 * This software is licensed under the terms of the GNU General Public
 * License version 2, as published by the Free Software Foundation, and
 * may be copied, distributed, and modified under those terms.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#ifndef INCLUDED_AMAZON_SDIO_H_
#define INCLUDED_AMAZON_SDIO_H_

#include <linux/netdevice.h>
#include <linux/mmc/sdio_func.h>

struct amazon_sdio_net_priv {
	struct net_device *ndev;
};


#define DRV_NAME	"amazon_sdio"
#define DRV_VERSION	"1.0"

struct net_device * amazon_sdio_ndev_create(int sizeof_priv);
void amazon_sdio_ndev_delete(struct net_device * ndev);


extern struct sdio_driver mt7682_amazon_sdio_driver;

int amazon_sdio_xmit(struct net_device *ndev, u8 *buf, u32 bufsize);

void amazon_sdio_flush_channel(struct net_device *dev,
			       uint8_t channel);

#endif // ifdef INCLUDED_AMAZON_SDIO_H_
